/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.commands.DumpDatapack;
import org.betterx.bclib.commands.PlaceCommand;
import org.betterx.bclib.commands.PrintInfo;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class CommandRegistry {
    private static final Map<Holder<Biome>, BlockState> biomeMap = new HashMap<Holder<Biome>, BlockState>();
    private static int biomeMapIdx = 0;
    private static final BlockState[] states = new BlockState[]{Blocks.f_50214_.m_49966_(), Blocks.f_50211_.m_49966_(), Blocks.f_50204_.m_49966_(), Blocks.f_50205_.m_49966_(), Blocks.f_50206_.m_49966_(), Blocks.f_50213_.m_49966_(), Blocks.f_50147_.m_49966_(), Blocks.f_50215_.m_49966_(), Blocks.f_50148_.m_49966_(), Blocks.f_50203_.m_49966_()};
    private static final BlockState[] states2 = new BlockState[]{Blocks.f_50504_.m_49966_(), Blocks.f_50501_.m_49966_(), Blocks.f_50494_.m_49966_(), Blocks.f_50495_.m_49966_(), Blocks.f_50496_.m_49966_(), Blocks.f_50503_.m_49966_(), Blocks.f_50542_.m_49966_(), Blocks.f_50505_.m_49966_(), Blocks.f_50543_.m_49966_(), Blocks.f_50545_.m_49966_()};

    public static void register() {
        CommandRegistrationCallback.EVENT.register(CommandRegistry::register);
    }

    private static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection commandSelection) {
        LiteralArgumentBuilder<CommandSourceStack> bnContext = (LiteralArgumentBuilder<CommandSourceStack>)Commands.m_82127_((String)"bclib").requires(source -> source.m_6761_(4));
        bnContext = PlaceCommand.register(bnContext, commandBuildContext);
        bnContext = PrintInfo.register(bnContext);
        bnContext = DumpDatapack.register(bnContext);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)bnContext.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"request_garbage_collection").requires(source -> source.m_6761_(4))).executes(CommandRegistry::requestGC))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"debug_ore").requires(source -> source.m_6761_(4))).executes(CommandRegistry::revealOre))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"sliceZ").requires(source -> source.m_6761_(4))).executes(ctx -> CommandRegistry.slice((CommandContext<CommandSourceStack>)ctx, true)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"sliceX").requires(source -> source.m_6761_(4))).executes(ctx -> CommandRegistry.slice((CommandContext<CommandSourceStack>)ctx, false))));
    }

    private static int requestGC(CommandContext<CommandSourceStack> ctx) {
        System.gc();
        return 1;
    }

    private static int revealOre(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerLevel level = source.m_81372_();
        Vec3 pos = source.m_81371_();
        BlockPos.MutableBlockPos bp = new BlockPos.MutableBlockPos();
        BlockState AIR = Blocks.f_50016_.m_49966_();
        for (int y = 1; y < level.m_141928_(); ++y) {
            bp.m_142448_(y);
            for (int x = -64; x < 64; ++x) {
                bp.m_142451_((int)pos.f_82479_ + x);
                for (int z = -64; z < 64; ++z) {
                    BlockState fillState;
                    bp.m_142443_((int)pos.f_82481_ + z);
                    if (y == 1) {
                        Holder b = level.m_204166_((BlockPos)bp);
                        fillState = biomeMap.computeIfAbsent((Holder<Biome>)b, bb -> {
                            biomeMapIdx = (biomeMapIdx + 1) % states.length;
                            return states[biomeMapIdx];
                        });
                    } else {
                        fillState = AIR;
                    }
                    BlockState state = level.m_8055_((BlockPos)bp);
                    if (y != 1 && state.m_60713_(Blocks.f_50016_) || state.m_204336_(CommonBlockTags.NETHER_ORES) || state.m_204336_(CommonBlockTags.END_ORES) || state.m_204336_(BlockTags.f_144262_) || state.m_204336_(BlockTags.f_144264_) || state.m_204336_(BlockTags.f_144259_) || state.m_204336_(BlockTags.f_144263_) || state.m_204336_(BlockTags.f_13043_) || state.m_204336_(BlockTags.f_144258_) || state.m_204336_(BlockTags.f_144261_) || state.m_204336_(BlockTags.f_144260_) || state.m_60713_(Blocks.f_50331_) || state.m_60713_(Blocks.f_49998_) || state.m_60713_(Blocks.f_50722_)) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)level, (BlockPos)bp, fillState);
                }
            }
        }
        return 1;
    }

    private static int slice(CommandContext<CommandSourceStack> ctx, boolean constX) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerLevel level = source.m_81372_();
        Vec3 pos = source.m_81371_();
        BlockState AIR = Blocks.f_50016_.m_49966_();
        BlockPos.MutableBlockPos bp = new BlockPos.MutableBlockPos();
        for (int y = 1; y < level.m_141928_(); ++y) {
            int x;
            bp.m_142448_(y);
            int n = x = constX ? 0 : -64;
            while (x < 64) {
                int z;
                bp.m_142451_((int)pos.f_82479_ + x);
                int n2 = z = constX ? -64 : 0;
                while (z < 64) {
                    BlockState fillState;
                    bp.m_142443_((int)pos.f_82481_ + z);
                    if (y == 1) {
                        Holder b = level.m_204166_((BlockPos)bp);
                        fillState = biomeMap.computeIfAbsent((Holder<Biome>)b, bb -> {
                            biomeMapIdx = (biomeMapIdx + 1) % states.length;
                            return states[biomeMapIdx];
                        });
                    } else {
                        fillState = AIR;
                    }
                    BlocksHelper.setWithoutUpdate((LevelAccessor)level, (BlockPos)bp, fillState);
                    ++z;
                }
                ++x;
            }
        }
        return 1;
    }

    private static int findSurface(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = source.m_81375_();
        Vec3 pos = source.m_81371_();
        ServerLevel level = source.m_81372_();
        BlockPos.MutableBlockPos mPos = new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_).m_122032_();
        System.out.println("Staring at: " + mPos + " -> " + level.m_8055_((BlockPos)mPos));
        boolean found = BlocksHelper.findSurroundingSurface((LevelAccessor)level, mPos, Direction.DOWN, 12, state -> BlocksHelper.isTerrain(state));
        System.out.println("Ending at: " + mPos + " -> " + level.m_8055_((BlockPos)mPos) + " = " + found);
        BlocksHelper.setWithoutUpdate((LevelAccessor)level, new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_), Blocks.f_50494_);
        BlocksHelper.setWithoutUpdate((LevelAccessor)level, (BlockPos)mPos, Blocks.f_50545_);
        return 1;
    }
}

